package ru.yandex.partner.libs.extservice.balance;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.boot.context.properties.ConfigurationProperties;

import ru.yandex.partner.defaultconfiguration.rpc.BaseRpcConfig;
import ru.yandex.partner.defaultconfiguration.rpc.DefaultRpcConfig;

@ConfigurationProperties("balance")
@ParametersAreNonnullByDefault
public class BalanceXmlRpcConfig extends BaseRpcConfig {
    private Duration connectionTimeout;

    public BalanceXmlRpcConfig(DefaultRpcConfig defaultProps) {
        super(defaultProps);
    }

    public URL getServerURL() {
        try {
            return new URL(url);
        } catch (MalformedURLException e) {
            throw new RuntimeException("Can't create URL object from %s".formatted(url), e);
        }
    }

    public Duration getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

}
