package ru.yandex.partner.libs.extservice.balance;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.partner.libs.extservice.balance.exception.BalanceClientException;
import ru.yandex.partner.libs.extservice.balance.method.partnercontract.BalancePartnerContract;
import ru.yandex.partner.libs.extservice.balance.method.partnercontract.Bank;

public class SimpleBalanceService implements BalanceService {
    private static final Logger BALANCE_SERVICE_LOGGER = LoggerFactory.getLogger(SimpleBalanceService.class);

    private static final String PARTNER_CONTRACTS_METHOD_NAME = "Balance.GetPartnerContracts";
    private final BalanceXmlRpcClient balanceXmlRpcClient;

    public SimpleBalanceService(BalanceXmlRpcConfig config) {
        this.balanceXmlRpcClient = new BalanceXmlRpcClient(config);
    }

    @Override
    public List<BalancePartnerContract> getPartnerContracts(long clientId) {
        return getPartnerContracts(Map.of("ClientID", Long.toString(clientId)));
    }

    @Override
    public List<BalancePartnerContract> getPartnerContracts(String externalId) {
        return getPartnerContracts(Map.of("ExternalID", externalId));
    }

    @Override
    public Bank getBankByBik(String bik) {
        return getBank("Bik", bik);
    }

    @Override
    public Bank getBankBySwift(String swift) {
        return getBank("Swift", swift);
    }

    private Bank getBank(String searchType, String bankId) {
        try {
            var response = balanceXmlRpcClient.retriedCall("Balance2.GetBank",
                    new Object[]{Map.of(searchType, bankId)},
                    null,
                    null);

            return BalanceResponseConverter.convertBank(response, searchType.toLowerCase(), bankId);
        } catch (BalanceClientException e) {
            BALANCE_SERVICE_LOGGER.error("Can't find Bank by %s with id %s".formatted(searchType, bankId), e);
            return null;
        }
    }
    private List<BalancePartnerContract> getPartnerContracts(Map<Object, Object> params) {
        var response = (Object[]) balanceXmlRpcClient.retriedCall(
                PARTNER_CONTRACTS_METHOD_NAME,
                new Object[]{params},
                null,
                null);
        return Stream.of(response)
                .map(BalanceResponseConverter::convertPartnerContract)
                .collect(Collectors.toList());
    }
}
