package ru.yandex.partner.libs.extservice.balance.message;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ModelDocumentsMsg implements GettextMsg {
    OFFER_TEST_MODE(msg("Offer test mode")),
    OFFER_ACCEPTED(msg("Offer accepted"));

    private static final String KEYSET_NAME = "lib__Application__Model__Documents.pm";

    private final GettextMsgPayload payload;

    ModelDocumentsMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
