package ru.yandex.partner.libs.extservice.balance.message;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ModelOebsMsg implements GettextMsg {
    SENT_BY_EMAIL(msg("Sent by mail")),
    GOT_COPY_SEND_ORIGINAL(msg("Got a copy, send the original")),
    SIGNED(msg("Signed"));

    private static final String KEYSET_NAME = "lib__Application__Model__OEBS.pm";

    private final GettextMsgPayload payload;

    ModelOebsMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
