package ru.yandex.partner.libs.extservice.balance.method.partnercontract;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;

public class BalancePartnerContract {
    private final Person person;
    private final Contract contract;
    private final TreeSet<Collateral> collaterals;
    // добавляйте данные по мере необходимости

    public BalancePartnerContract(Person person, Contract contract, Collection<Collateral> collaterals) {
        this.person = person;
        this.contract = contract;
        this.collaterals = new TreeSet<>(Comparator.comparing(Collateral::getDt));
        this.collaterals.addAll(collaterals);
    }

    public Optional<Person> getPerson() {
        return Optional.ofNullable(person);
    }

    public Optional<Contract> getContract() {
        return Optional.ofNullable(contract);
    }

    public Stream<Collateral> collateralDtSortedStream() {
        return collaterals.stream();
    }

    /**
     * Проверка, что договор действует
     *
     * @param date Дата относительно которой проверяем
     * @return true если сам contract активен и нет допсоглашений "расторжение договора" или "уведомление о закрытии"
     *         иначе false
     */
    public boolean isLive(LocalDate date) {
        return contract.isLive(date) &&
                collaterals.stream()
                        .noneMatch(collateral ->
                                collateral.isTermination(date) || collateral.isNotificationAboutClose(date)
                        );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BalancePartnerContract)) {
            return false;
        }
        BalancePartnerContract that = (BalancePartnerContract) o;
        return Objects.equals(person, that.person) &&
                Objects.equals(contract, that.contract) &&
                collaterals.equals(that.collaterals);
    }

    @Override
    public int hashCode() {
        return Objects.hash(person, contract, collaterals);
    }
}
