package ru.yandex.partner.libs.extservice.balance.method.partnercontract;

import java.util.Objects;

import ru.yandex.partner.core.entity.balance.model.BalanceBank;

public class Bank {
    private final boolean active;
    private final String bankId;
    private final String bankIdType;
    private final String name;

    public Bank(boolean active, String bankId, String bankIdType, String name) {
        this.active = active;
        this.bankId = bankId;
        this.bankIdType = bankIdType;
        this.name = name;
    }

    public BalanceBank toBalanceBank() {
        return new BalanceBank()
                .withActive(active)
                .withBankId(bankId)
                .withBankIdType(bankIdType)
                .withName(name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bank)) {
            return false;
        }
        Bank bank = (Bank) o;
        return active == bank.active &&
                Objects.equals(bankId, bank.bankId) &&
                Objects.equals(bankIdType, bank.bankIdType) &&
                Objects.equals(name, bank.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(active, bankId, bankIdType, name);
    }

    @Override
    public String toString() {
        return "Bank{" +
                "active=" + active +
                ", bankId='" + bankId + '\'' +
                ", bankIdType='" + bankIdType + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
