package ru.yandex.partner.libs.extservice.balance.method.partnercontract;

import java.util.Objects;

import ru.yandex.partner.core.entity.balance.model.BalanceBank;
import ru.yandex.partner.core.entity.balance.model.BalancePerson;

public class Person {
    private final long id;
    private final long clientId;
    private final String login;
    private final String name;
    private final String longname;
    private final String phone;
    private final String email;
    private final String fax;
    private final String legaladdress;
    private final String representative;
    private final String account;
    private final String authorityDocType;
    private final String benBank;
    private final String benAccount;
    private final String bik;
    private final String iban;
    private final String inn;
    private final String kpp;
    private final String other;
    private final String personAccount;
    private final String postaddress;
    private final String signerPersonName;
    private final String signerPositionName;
    private final String swift;
    private final String yamoneyWallet;
    private final String payoneerWallet;
    private final String type;

    private Person(Builder builder) {
        this.id = builder.id;
        this.clientId = builder.clientId;
        this.login = builder.login;
        this.name = builder.name;
        this.longname = builder.longname;
        this.phone = builder.phone;
        this.email = builder.email;
        this.fax = builder.fax;
        this.legaladdress = builder.legaladdress;
        this.representative = builder.representative;
        this.account = builder.account;
        this.authorityDocType = builder.authorityDocType;
        this.benBank = builder.benBank;
        this.benAccount = builder.benAccount;
        this.bik = builder.bik;
        this.iban = builder.iban;
        this.inn = builder.inn;
        this.kpp = builder.kpp;
        this.other = builder.other;
        this.personAccount = builder.personAccount;
        this.postaddress = builder.postaddress;
        this.signerPersonName = builder.signerPersonName;
        this.signerPositionName = builder.signerPositionName;
        this.swift = builder.swift;
        this.yamoneyWallet = builder.yamoneyWallet;
        this.payoneerWallet = builder.payoneerWallet;
        this.type = builder.type;
    }

    public long getClientId() {
        return clientId;
    }

    public String getBik() {
        return bik;
    }

    public String getSwift() {
        return swift;
    }

    public BalancePerson toBalancePerson(BalanceBank balanceBank) {
        return new BalancePerson()
                .withId(id)
                .withClientId(clientId)
                .withLogin(login)
                .withName(name)
                .withLongname(longname)
                .withPhone(phone)
                .withEmail(email)
                .withFax(fax)
                .withLegalAddress(legaladdress)
                .withRepresentative(representative)
                .withAccount(account)
                .withAuthorityDocType(authorityDocType)
                .withBenAccount(benAccount)
                .withBenBank(benBank)
                .withBik(bik)
                .withIban(iban)
                .withInn(inn)
                .withKpp(kpp)
                .withOther(other)
                .withPersonAccount(personAccount)
                .withPostAddress(postaddress)
                .withSignerPersonName(signerPersonName)
                .withSignerPositionName(signerPositionName)
                .withSwift(swift)
                .withYamoneyWallet(yamoneyWallet)
                .withBank(balanceBank)
                .withPayoneerWallet(payoneerWallet)
                .withType(type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person) o;
        return id == person.id &&
                clientId == person.clientId &&
                Objects.equals(login, person.login) &&
                Objects.equals(name, person.name) &&
                Objects.equals(longname, person.longname) &&
                Objects.equals(phone, person.phone) &&
                Objects.equals(email, person.email) &&
                Objects.equals(fax, person.fax) &&
                Objects.equals(legaladdress, person.legaladdress) &&
                Objects.equals(representative, person.representative) &&
                Objects.equals(account, person.account) &&
                Objects.equals(authorityDocType, person.authorityDocType) &&
                Objects.equals(benBank, person.benBank) &&
                Objects.equals(benAccount, person.benAccount) &&
                Objects.equals(bik, person.bik) &&
                Objects.equals(iban, person.iban) &&
                Objects.equals(inn, person.inn) &&
                Objects.equals(kpp, person.kpp) &&
                Objects.equals(other, person.other) &&
                Objects.equals(personAccount, person.personAccount) &&
                Objects.equals(postaddress, person.postaddress) &&
                Objects.equals(signerPersonName, person.signerPersonName) &&
                Objects.equals(signerPositionName, person.signerPositionName) &&
                Objects.equals(swift, person.swift) &&
                Objects.equals(yamoneyWallet, person.yamoneyWallet) &&
                Objects.equals(payoneerWallet, person.payoneerWallet) &&
                Objects.equals(type, person.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, clientId, login, name, longname, phone, email, fax, legaladdress, representative,
                account, authorityDocType, benBank, benAccount, bik, iban, inn, kpp, other, personAccount,
                postaddress, signerPersonName, signerPositionName, swift, yamoneyWallet, payoneerWallet, type);
    }

    public static class Builder {
        private long id;
        private long clientId;
        private String login;
        private String name;
        private String longname;
        private String phone;
        private String email;
        private String fax;
        private String legaladdress;
        private String representative;
        private String account;
        private String authorityDocType;
        private String benBank;
        private String benAccount;
        private String bik;
        private String iban;
        private String inn;
        private String kpp;
        private String other;
        private String personAccount;
        private String postaddress;
        private String signerPersonName;
        private String signerPositionName;
        private String swift;
        private String yamoneyWallet;
        private String payoneerWallet;
        private String type;

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withClientId(long clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withLongname(String longname) {
            this.longname = longname;
            return this;
        }

        public Builder withPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withFax(String fax) {
            this.fax = fax;
            return this;
        }

        public Builder withLegaladdress(String legaladdress) {
            this.legaladdress = legaladdress;
            return this;
        }

        public Builder withRepresentative(String representative) {
            this.representative = representative;
            return this;
        }

        public Builder withAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder withAuthorityDocType(String authorityDocType) {
            this.authorityDocType = authorityDocType;
            return this;
        }

        public Builder withBenBank(String benBank) {
            this.benBank = benBank;
            return this;
        }

        public Builder withBenAccount(String benAccount) {
            this.benAccount = benAccount;
            return this;
        }

        public Builder withBik(String bik) {
            this.bik = bik;
            return this;
        }

        public Builder withIban(String iban) {
            this.iban = iban;
            return this;
        }

        public Builder withInn(String inn) {
            this.inn = inn;
            return this;
        }

        public Builder withKpp(String kpp) {
            this.kpp = kpp;
            return this;
        }

        public Builder withOther(String other) {
            this.other = other;
            return this;
        }

        public Builder withPersonAccount(String personAccount) {
            this.personAccount = personAccount;
            return this;
        }

        public Builder withPostaddress(String postaddress) {
            this.postaddress = postaddress;
            return this;
        }

        public Builder withSignerPersonName(String signerPersonName) {
            this.signerPersonName = signerPersonName;
            return this;
        }

        public Builder withSignerPositionName(String signerPositionName) {
            this.signerPositionName = signerPositionName;
            return this;
        }

        public Builder withSwift(String swift) {
            this.swift = swift;
            return this;
        }

        public Builder withYamoneyWallet(String yamoneyWallet) {
            this.yamoneyWallet = yamoneyWallet;
            return this;
        }

        public Builder withPayoneerWallet(String payoneerWallet) {
            this.payoneerWallet = payoneerWallet;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Person build() {
            return new Person(this);
        }
    }
}
