package ru.yandex.partner.libs.extservice.balance.xml;

public class LongXmlAttribute implements XmlAttribute {
    private final String name;
    private final Long value;

    public LongXmlAttribute(String name, Long value) {
        this.name = name;
        this.value = value;
    }
    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getType() {
        return "int";
    }

    @Override
    public String getValue() {
        return value == null
                ? ""
                : value.toString();
    }
}
