package ru.yandex.partner.libs.extservice.balance.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class XmlBody {
    private final String methodName;
    private final List<XmlAttribute> attributes;

    public XmlBody(String methodName, List<XmlAttribute> attributes) {
        this.methodName = methodName;
        this.attributes = attributes;
    }

    public String getMethodName() {
        return methodName;
    }

    public String body() throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("methodCall");

        root.addElement("methodName")
                .addText(this.methodName);

        Element structValues = root.addElement("params")
                .addElement("param")
                .addElement("value")
                .addElement("struct");

        for (XmlAttribute attribute : attributes) {
            Element memberElement = structValues.addElement("member");
            memberElement.addElement("name")
                    .addText(attribute.getName());
            memberElement.addElement("value")
                    .addElement(attribute.getType())
                    .addText(attribute.getValue());
        }

        try (ByteArrayOutputStream bas = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(bas)) {
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.write(document);
            xmlWriter.close();
            return bas.toString();
        }
    }

    public static class Builder {
        private String methodName;
        private List<XmlAttribute> attributes = new ArrayList<>();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder withAttribute(XmlAttribute xmlAttribute) {
            attributes.add(xmlAttribute);
            return this;
        }

        public XmlBody build() {
            return new XmlBody(methodName, attributes);
        }
    }
}
