package ru.yandex.partner.libs.extservice.blackbox;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import ru.yandex.partner.defaultconfiguration.rpc.BaseRpcConfig;
import ru.yandex.partner.defaultconfiguration.rpc.DefaultRpcConfig;

@Component
@ConfigurationProperties("blackbox")
public class BlackBoxRtcConfig extends BaseRpcConfig {
    private Integer maxConnections;
    private String tvmAlias;
    private String clientIpStub;

    public BlackBoxRtcConfig(DefaultRpcConfig defaultProps) {
        super(defaultProps);
    }


    public Integer getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getTvmAlias() {
        return tvmAlias;
    }

    public void setTvmAlias(String tvmAlias) {
        this.tvmAlias = tvmAlias;
    }

    public String getClientIpStub() {
        return clientIpStub;
    }

    public void setClientIpStub(String clientIpStub) {
        this.clientIpStub = clientIpStub;
    }
}
