package ru.yandex.partner.libs.extservice.direct;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AppInfo {
    private String title;
    private String iconUrl;
    private Integer platform;
    private String bundleId;
    /*author*/
    private String vendor;
    private String region;
    private String url;
    /*store_id*/
    private String appId;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    public String getBundleId() {
        return bundleId;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppInfo appInfo = (AppInfo) o;
        return Objects.equals(title, appInfo.title)
                && Objects.equals(iconUrl, appInfo.iconUrl)
                && Objects.equals(platform, appInfo.platform)
                && Objects.equals(bundleId, appInfo.bundleId)
                && Objects.equals(vendor, appInfo.vendor)
                && Objects.equals(region, appInfo.region)
                && Objects.equals(url, appInfo.url)
                && Objects.equals(appId, appInfo.appId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(title, iconUrl, platform, bundleId, vendor, region, url, appId);
    }

    @Override
    public String toString() {
        return "AppInfo{" +
                "title='" + title + '\'' +
                ", iconUrl='" + iconUrl + '\'' +
                ", platform=" + platform +
                ", bundleId='" + bundleId + '\'' +
                ", vendor='" + vendor + '\'' +
                ", region='" + region + '\'' +
                ", url='" + url + '\'' +
                ", appId='" + appId + '\'' +
                '}';
    }
}
