package ru.yandex.partner.libs.extservice.direct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import ru.yandex.partner.defaultconfiguration.CacheNames;

@Service
public class CacheableDirectIntapiService implements DirectIntapiService {
    private final DirectIntapiService delegate;

    @Autowired
    public CacheableDirectIntapiService(DirectIntapiService delegate) {
        this.delegate = delegate;
    }

    @Override
    @Cacheable(value = {CacheNames.DIRECT_INTAPI_APP_INFO}, unless = "#result == null")
    public AppInfo appInfoParsing(String appUrl) {
        return delegate.appInfoParsing(appUrl);
    }
}
