package ru.yandex.partner.libs.extservice.saas.filter;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SaasFilter implements SaasQueryPart {
    private final String key;
    private final String prefix;

    public SaasFilter(String key, String prefix) {
        this.key = key;
        // Включение режима объектного саджеста в SAAS происходит через * в конце запроса
        // SAAS требует хотя бы один символ, чтобы саджест работал
        if (prefix.length() < 1) {
            this.prefix = "\"a*\"";
        } else {
            this.prefix = String.format("\"%s*\"", prefix);
        }
    }

    @Override
    public String getSaasQuery() {
        return String.format("%s:%s", this.key, this.prefix);
    }
}
