package ru.yandex.partner.libs.extservice.saas.filter;

import java.util.List;
import java.util.stream.Collectors;

import one.util.streamex.StreamEx;

public class SaasFilterExpression implements SaasQueryPart {
    private final SaasFilterLogicOperator logicOperator;
    private final List<SaasQueryPart> filters;

    private SaasFilterExpression(SaasFilterLogicOperator logicOperator, List<SaasQueryPart> filters) {
        this.logicOperator = logicOperator;
        this.filters = filters;
    }

    private SaasFilterExpression(SaasFilterLogicOperator logicOperator, SaasQueryPart... filters) {
        this(logicOperator, StreamEx.of(filters).toList());
    }

    public static SaasQueryPart or(SaasQueryPart... filters) {
        if (filters.length == 1) {
            return filters[0];
        }
        return new SaasFilterExpression(SaasFilterLogicOperator.OR, filters);
    }

    public static SaasQueryPart or(List<SaasQueryPart> filters) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new SaasFilterExpression(SaasFilterLogicOperator.OR, filters);
    }

    public static SaasQueryPart and(SaasQueryPart... filters) {
        if (filters.length == 1) {
            return filters[0];
        }
        return new SaasFilterExpression(SaasFilterLogicOperator.AND, filters);
    }

    public static SaasQueryPart and(List<SaasQueryPart> filters) {
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new SaasFilterExpression(SaasFilterLogicOperator.AND, filters);
    }

    @Override
    public String getSaasQuery() {
        return '(' +
                filters.stream()
                        .map(SaasQueryPart::getSaasQuery)
                        .collect(Collectors.joining(logicOperator.getSaasFormat())) +
                ')';
    }

}
