package ru.yandex.partner.libs.extservice.saas.response;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.apache.commons.lang3.tuple.Pair;

@JsonNaming(PropertyNamingStrategies.UpperCamelCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArchiveInfo {
    private List<GtaRelatedAttribute> gtaRelatedAttribute;
    private String url;

    public List<GtaRelatedAttribute> getGtaRelatedAttribute() {
        return gtaRelatedAttribute;
    }

    public void setGtaRelatedAttribute(List<GtaRelatedAttribute> gtaRelatedAttribute) {
        this.gtaRelatedAttribute = gtaRelatedAttribute;
    }

    public Map<String, String> toMap() {
        return gtaRelatedAttribute
                .stream()
                .map(it -> Pair.of(it.getKey(), it.getValue()))
                .collect(Collectors.toUnmodifiableMap(Pair::getLeft, Pair::getRight));
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

}
