package ru.yandex.partner.libs.extservice.saas.response;


import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum AttributeNames {
    TITLE("z_title"),
    ICON("s_icon"),
    PLATFORM("s_platform"),
    BUNDLE("s_bundle_id"),
    AUTHOR("z_author"),
    APP_ID("s_app_id"),
    STORE("s_store"),
    URL("URL"),
    REGION("s_region");

    public static final Set<String> APP_ATTR_NAMES = Arrays.stream(values()).map(AttributeNames::getSaasName)
            .collect(Collectors.toSet());

    private final String saasName;

    AttributeNames(String saasName) {
        this.saasName = saasName;
    }

    public String getSaasName() {
        return saasName;
    }
}
