package ru.yandex.partner.libs.extservice.balance;

import java.time.LocalDate;
import java.util.Map;

import org.junit.jupiter.api.Test;

import ru.yandex.partner.libs.extservice.balance.method.partnercontract.Bank;

import static org.junit.jupiter.api.Assertions.assertEquals;

class BalanceResponseConverterTest {

    @Test
    void convertBank() {
        Bank bank  = BalanceResponseConverter.convertBank(
                Map.of("hidden", 1, "name", "name1"),
                "bankIdType1", "bankId1"
        );

        assertEquals(new Bank(false, "bankId1", "bankIdType1", "name1"), bank);

        bank  = BalanceResponseConverter.convertBank(
                Map.of("hidden_dt", LocalDate.now(), "name", "name2"),
                "bankIdType2", "bankId2"
        );

        assertEquals(new Bank(false, "bankId2", "bankIdType2", "name2"), bank);

        bank  = BalanceResponseConverter.convertBank(
                Map.of("name", "name3"),
                "bankIdType3", "bankId3"
        );

        assertEquals(new Bank(true, "bankId3", "bankIdType3", "name3"), bank);
    }
}
