package ru.yandex.partner.libs.extservice.balance.method.partnercontract;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

class BalancePartnerContractTest {

    @Test
    void contractIsCancelled() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsSigned(LocalDate.of(2000, 1, 1))
                        .withIsCancelled(LocalDate.of(2014, 1, 17))
                        .build(),
                Collections.emptyList()
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }

    @Test
    void contractEndDt() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsSigned(LocalDate.of(2000, 1, 1))
                        .withEndDt(LocalDate.of(2014, 1, 16))
                        .build(),
                Collections.emptyList()
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }

    @Test
    void contractIsInFuture() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2014, 1, 17))
                        .withIsSigned(LocalDate.of(2000, 1, 1))
                        .build(),
                Collections.emptyList()
        );

        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }


    @Test
    void collateralClosed2090() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsSigned(LocalDate.of(2000, 1, 1))
                        .build(),
                List.of(
                        new Collateral.Builder()
                                .withDt(LocalDate.of(2000, 1, 1))
                                .withCollateralTypeId(2090)
                                .withEndDt(LocalDate.of(2014, 1, 16))
                                .build()
                )
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }

    @Test
    void contractIsNotSignedAndIsNotFaxed() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withContractType(9)
                        .withTestMode(0)
                        .build(),
                Collections.emptyList()
        );

        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }


    @Test
    void contractIsOferta2TestMode() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withContractType(9)
                        .withTestMode(1)
                        .build(),
                Collections.emptyList()
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }


    @Test
    void contractIsSigned() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsSigned(LocalDate.of(2014, 1, 10))
                        .build(),
                Collections.emptyList()
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }


    @Test
    void contractIsFaxed() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsFaxed(LocalDate.of(2014, 1, 17))
                        .build(),
                Collections.emptyList()
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }


    @Test
    void collateralCancellation2050() {
        BalancePartnerContract partnerContract = new BalancePartnerContract(
                new Person.Builder().build(),
                new Contract.Builder()
                        .withDt(LocalDate.of(2000, 1, 1))
                        .withIsSigned(LocalDate.of(2000, 1, 1))
                        .build(),
                List.of(
                        new Collateral.Builder()
                                .withCollateralTypeId(2050)
                                .withDt(LocalDate.of(2000, 1, 1))
                                .withEndDt(LocalDate.of(2014, 1, 16))
                                .withIsFaxed(LocalDate.of(2014, 1, 16))
                                .build()
                )
        );

        assertTrue(partnerContract.isLive(LocalDate.of(2014, 1, 16)));
        assertFalse(partnerContract.isLive(LocalDate.of(2014, 1, 17)));
    }

}
