package ru.yandex.partner.libs.extservice.balance.method.partnercontract;

import java.time.LocalDate;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

class ContractTest {

    @Test
    void contractAllowsToFillPart2() {
        Contract contract = new Contract.Builder()
                .withDt(LocalDate.of(2000, 1, 1))
                .withContractType(9)
                .withTestMode(1)
                .build();

        assertTrue(contract.allowsToFillPart2());
    }


    @Test
    void contractNotAllowsToFillPart2() {
        Contract contract = new Contract.Builder()
                .withDt(LocalDate.of(2000, 1, 1))
                .withContractType(9)
                .withTestMode(1)
                .withPersonId(12345L)
                .build();

        assertFalse(contract.allowsToFillPart2());

        contract = new Contract.Builder()
                .withDt(LocalDate.of(2000, 1, 1))
                .withContractType(9)
                .withTestMode(0)
                .build();

        assertFalse(contract.allowsToFillPart2());
    }
}
