package ru.yandex.partner.libs.extservice.saas;

import org.junit.jupiter.api.Test;

import ru.yandex.partner.libs.extservice.saas.filter.SaasFilter;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static ru.yandex.partner.libs.extservice.saas.filter.SaasFilterExpression.and;
import static ru.yandex.partner.libs.extservice.saas.filter.SaasFilterExpression.or;

class SaasFilterTest {

    @Test
    void testFilter() {
        var filter = and(new SaasFilter("s_region", "ru"),
                or(new SaasFilter("z_title", "Yandex"),
                        new SaasFilter("s_bundle_id", "ru.yandex.navigator"))).getSaasQuery();

        assertEquals(filter, "(s_region:\"ru*\" (z_title:\"Yandex*\" | s_bundle_id:\"ru.yandex.navigator*\"))");

    }

}
