package ru.yandex.direct.hourglass.mysql.storage;

import java.util.Collection;

import ru.yandex.direct.hourglass.storage.Job;
import ru.yandex.direct.hourglass.storage.JobStatus;
import ru.yandex.direct.hourglass.storage.PrimaryId;
import ru.yandex.direct.hourglass.storage.TaskId;
import ru.yandex.direct.hourglass.storage.implementations.Find;

public class StorageFindImpl implements Find {
    private final StorageImpl storage;
    private Collection<PrimaryId> primaryIds = null;
    private JobStatus jobStatus = null;
    private boolean nextRunLessThanNow = false;
    private Boolean needReschedule = null;
    private TaskId taskId = null;

    StorageFindImpl(StorageImpl storage) {
        this.storage = storage;
    }

    @Override
    public Find wherePrimaryIdIn(Collection<PrimaryId> primaryIds) {
        this.primaryIds = primaryIds;
        return this;
    }

    @Override
    public Find whereJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    @Override
    public Find whereNextRunLeNow() {
        nextRunLessThanNow = true;
        return this;
    }

    @Override
    public Find whereTaskId(TaskId taskId) {
        this.taskId = taskId;
        return this;
    }

    boolean isNextRunLessThanNow() {
        return nextRunLessThanNow;
    }

    Collection<PrimaryId> getPrimaryIds() {
        return primaryIds;
    }

    JobStatus getJobStatus() {
        return jobStatus;
    }

    Boolean getNeedReschedule() {
        return needReschedule;
    }

    TaskId getTaskId() {
        return taskId;
    }

    @Override
    public Collection<Job> findJobs(int limit) {
        return storage.findJobs(this, limit);
    }

    @Override
    public Collection<PrimaryId> findPrimaryIds(int limit) {
        return storage.findPrimaryId(this, limit);
    }

    @Override
    public Collection<PrimaryId> findPrimaryIds() {
        return storage.findPrimaryId(this, Integer.MAX_VALUE);
    }

    @Override
    public Collection<Job> findJobs() {
        return storage.findJobs(this, Integer.MAX_VALUE);
    }

    @Override
    public Find whereNeedReschedule(boolean b) {
        this.needReschedule = b;
        return this;
    }

}
