package ru.yandex.direct.hourglass.mysql;

import java.sql.Connection;
import java.sql.SQLException;

import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.SQLDialect;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;

import ru.yandex.direct.mysql.MySQLInstance;
import ru.yandex.direct.test.mysql.DirectMysqlDb;
import ru.yandex.direct.test.mysql.TestMysqlConfig;

public class DslContextHolder {
    private static volatile DSLContext dslContext = null;

    private DslContextHolder() {
    }

    public static DSLContext getDslContext() throws SQLException, InterruptedException {

        if (dslContext == null) {
            synchronized (DslContextHolder.class) {
                if (dslContext == null) {
                    MySQLInstance mysql = new DirectMysqlDb(TestMysqlConfig.directConfig()).start();
                    Connection conn = mysql.connect();

                    Configuration configuration = new DefaultConfiguration()
                            .set(conn)
                            .set(SQLDialect.MYSQL)
                            .set(new DefaultExecuteListenerProvider(new PrettyPrinter()));

                    dslContext = DSL.using(configuration);
                }
            }
        }

        return dslContext;
    }

    public static class PrettyPrinter extends DefaultExecuteListener {

        /**
         * Hook into the query execution lifecycle before executing queries
         */
        @Override
        public void executeStart(ExecuteContext ctx) {

            // Create a new DSLContext for logging rendering purposes
            // This DSLContext doesn't need a connection, only the SQLDialect...
            DSLContext create = DSL.using(ctx.dialect(),

                    // ... and the flag for pretty-printing
                    new Settings().withRenderFormatted(true));

            // If we're executing a query
            if (ctx.query() != null) {
                System.out.println(create.renderInlined(ctx.query()));
            } else if (ctx.routine() != null) {
                // If we're executing a routine
                System.out.println(create.renderInlined(ctx.routine()));
            }
        }
    }
}
