package ru.yandex.partner.libs.i18n;

import javax.annotation.Nonnull;

import org.springframework.context.MessageSourceResolvable;

public interface GettextMsg extends MessageSourceResolvable {

    @Nonnull
    GettextMsgPayload getPayload();

    @Nonnull
    String getKeysetName();

    @Override
    default String[] getCodes() {
        GettextMsgPayload payload = getPayload();
        if (payload.isPlural()) {
            return new String[]{payload.getMsg(), payload.getPluralMsg()};
        } else {
            return new String[]{payload.getMsg()};
        }
    }

    @Override
    default String getDefaultMessage() {
        Object[] arguments = getArguments();
        GettextMsgPayload payload = getPayload();
        if (arguments != null && arguments.length > 0) {
            return String.format(payload.getMsg(), arguments);
        }

        return payload.getMsg();
    }

    default MsgWithArgs format(Object... args) {
        return MsgWithArgs.of(this, args);
    }
}
