package ru.yandex.partner.libs.i18n;

import java.util.Objects;

public class GettextMsgPayload {

    private final String msg;
    private final boolean isPlural;
    private final int pluralArgIndex;
    private final String pluralMsg;
    private final boolean isContext;
    private final String context;

    public String getMsg() {
        return msg;
    }

    public boolean isPlural() {
        return isPlural;
    }

    public int getPluralArgIndex() {
        return pluralArgIndex;
    }

    public String getPluralMsg() {
        return pluralMsg;
    }

    public boolean isContext() {
        return isContext;
    }

    public String getContext() {
        return context;
    }

    private GettextMsgPayload(String msg, boolean isPlural, int pluralArgIndex, String pluralMsg,
                              boolean isContext, String context) {
        this.msg = msg;
        this.isPlural = isPlural;
        this.pluralArgIndex = pluralArgIndex;
        this.pluralMsg = pluralMsg;
        this.isContext = isContext;
        this.context = context;
    }

    public static class Builder {

        private String msg;
        private boolean isPlural = false;
        private int pluralArgIndex = 0;
        private String pluralMsg = null;
        private boolean isContext = false;
        private String context = null;

        public static Builder msg(String msg) {
            return new Builder(msg);
        }

        public Builder plural(int pluralArgIndex, String pluralMsg) {
            this.isPlural = true;
            this.pluralArgIndex = pluralArgIndex;
            this.pluralMsg = pluralMsg;
            return this;
        }

        public Builder plural(String pluralMsg) {
            return this.plural(0, pluralMsg);
        }

        public Builder context(String context) {
            this.isContext = true;
            this.context = context;
            return this;
        }

        public GettextMsgPayload build() {
            return new GettextMsgPayload(this.msg,
                    this.isPlural, this.pluralArgIndex, this.pluralMsg,
                    this.isContext, this.context
            );
        }

        private Builder(String msg) {
            this.msg = msg;
        }

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GettextMsgPayload)) {
            return false;
        }
        GettextMsgPayload that = (GettextMsgPayload) o;
        return isPlural == that.isPlural &&
                pluralArgIndex == that.pluralArgIndex &&
                isContext == that.isContext &&
                Objects.equals(msg, that.msg) &&
                Objects.equals(pluralMsg, that.pluralMsg) &&
                Objects.equals(context, that.context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(msg, isPlural, pluralArgIndex, pluralMsg, isContext, context);
    }

    @Override
    public String toString() {
        return "GettextMsgPayload{" +
                "msg='" + msg + '\'' +
                ", isPlural=" + isPlural +
                ", pluralArgIndex=" + pluralArgIndex +
                ", pluralMsg='" + pluralMsg + '\'' +
                ", isContext=" + isContext +
                ", context='" + context + '\'' +
                '}';
    }
}
