package ru.yandex.partner.libs.i18n;

import java.util.Arrays;
import java.util.Objects;

import javax.annotation.Nonnull;

public class MsgWithArgs implements GettextMsg {

    private final GettextMsgPayload payload;
    private final String keysetName;
    private final Object[] arguments;

    private MsgWithArgs(GettextMsgPayload payload, String keysetName, Object[] arguments) {
        this.payload = payload;
        this.keysetName = keysetName;
        this.arguments = arguments;
    }

    public static MsgWithArgs of(GettextMsg gettextMsg, Object... arguments) {
        return new MsgWithArgs(gettextMsg.getPayload(), gettextMsg.getKeysetName(), arguments);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return this.payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keysetName;
    }

    @Override
    public Object[] getArguments() {
        return arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MsgWithArgs)) {
            return false;
        }
        MsgWithArgs that = (MsgWithArgs) o;
        return Objects.equals(payload, that.payload) &&
                Objects.equals(keysetName, that.keysetName) &&
                Arrays.equals(arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(payload, keysetName);
        result = 31 * result + Arrays.hashCode(arguments);
        return result;
    }

    @Override
    public String toString() {
        return "MsgWithArgs{" +
                "payload=" + payload +
                ", keysetName='" + keysetName + '\'' +
                ", arguments=" + Arrays.toString(arguments) +
                '}';
    }
}
