package ru.yandex.partner.libs.i18n;

import java.util.Locale;
import java.util.Objects;

import javax.annotation.Nonnull;

import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class RawMessageSource implements MessageSource {

    @Override
    public String getMessage(@Nonnull String code, Object[] args, String defaultMessage, @Nonnull Locale locale) {
        return getMessageInternal(code, args);
    }

    @Nonnull
    @Override
    public String getMessage(@Nonnull String code, Object[] args, @Nonnull Locale locale)
            throws NoSuchMessageException {

        return getMessageInternal(code, args);
    }

    @Nonnull
    @Override
    public String getMessage(@Nonnull MessageSourceResolvable resolvable, @Nonnull Locale locale)
            throws NoSuchMessageException {

        String[] codes = resolvable.getCodes();
        Object[] args = resolvable.getArguments();
        if (codes != null) {
            for (String code : codes) {
                if (code != null) {
                    return getMessageInternal(code, args);
                }
            }
        }

        return Objects.requireNonNullElse(resolvable.getDefaultMessage(), "Unknown message");
    }

    private String getMessageInternal(@Nonnull String code, Object[] args) {
        if (args == null || args.length == 0) {
            return code;
        } else {
            return String.format(code, args);
        }
    }
}
