package ru.yandex.partner.libs.i18n.escaper;

import java.util.List;
import java.util.stream.Collectors;

public interface StringEscaper {

    String escapeString(String unescapedString);

    String unescapeString(String escapedString);

    default Object unsecapeResource(Object value) {
        if (value instanceof String) {
            return unescapeString((String) value);
        } else if (value instanceof List) {
            return ((List<?>) value).stream()
                    .map(v -> v instanceof String ? unescapeString((String) v) : "")
                    .collect(Collectors.toList());
        }
        return "";
    }

}
