package ru.yandex.partner.libs.i18n.gettext;

import java.util.List;
import java.util.ResourceBundle;

import com.google.common.base.Strings;

import ru.yandex.partner.libs.i18n.GettextException;
import ru.yandex.partner.libs.i18n.resolver.key.GettextMessageKeyResolver;
import ru.yandex.partner.libs.i18n.resolver.plural.DefaultPluralVariantResolver;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolver;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolverProvider;

public class GettextImpl implements Gettext {

    private static final PluralVariantResolver defaultPluralVariantResolver = new DefaultPluralVariantResolver();

    private final GettextMessageKeyResolver gettextMessageKeyResolver;

    public GettextImpl(GettextMessageKeyResolver gettextMessageKeyResolver) {
        this.gettextMessageKeyResolver = gettextMessageKeyResolver;
    }

    @Override
    public String getText(ResourceBundle resourceBundle, String msg) {
        String key = gettextMessageKeyResolver.generateNonContextualKey(msg);
        String result = getTextNull(resourceBundle, key);
        if (!Strings.isNullOrEmpty(result)) {
            return result;
        }
        return msg;
    }

    @Override
    public String pGetText(ResourceBundle resourceBundle, String msg, String context) {
        String fullKey = gettextMessageKeyResolver.generateContextualKey(msg, context);
        String result = getTextNull(resourceBundle, fullKey);
        if (!Strings.isNullOrEmpty(result)) {
            return result;
        }
        return getText(resourceBundle, msg);
    }

    @Override
    public String nGetText(ResourceBundle resourceBundle, String msg, int n, String defaultPluralMsg) {
        String key = gettextMessageKeyResolver.generateNonContextualKey(msg);
        String result = nGetTextNull(resourceBundle, key, n);
        if (!Strings.isNullOrEmpty(result)) {
            return result;
        }
        return defaultPluralVariantResolver.resolvePluralVariant(n) == 0 ? msg : defaultPluralMsg;
    }

    @Override
    public String npGetText(ResourceBundle resourceBundle, String msg, int n, String defaultPluralMsg,
                            String context) {
        String fullKey = gettextMessageKeyResolver.generateContextualKey(msg, context);
        String result = nGetTextNull(resourceBundle, fullKey, n);
        if (!Strings.isNullOrEmpty(result)) {
            return result;
        }
        return nGetText(resourceBundle, msg, n, defaultPluralMsg);
    }

    private String getTextNull(ResourceBundle resourceBundle, String key) {
        return getVariant(resourceBundle, key, 0);
    }

    private String nGetTextNull(ResourceBundle resourceBundle, String key, int n) {
        PluralVariantResolver pluralVariantResolver
                = PluralVariantResolverProvider.getPluralVariantResolver(resourceBundle.getLocale());
        return getVariant(resourceBundle, key, pluralVariantResolver.resolvePluralVariant(n));
    }

    private String getVariant(ResourceBundle resourceBundle, String key, int i) {
        if (!resourceBundle.containsKey(key)) {
            return null;
        }
        return getStringFromResource(resourceBundle.getObject(key), i);
    }

    private String getStringFromResource(Object resource, int i) {
        if (resource instanceof String) {
            return (String) resource;
        }
        if (resource instanceof List) {
            final List list = (List) resource;
            if (list.size() > 0) {
                final Object item = (list.size() > i) ? list.get(i) : list.get(0);
                if (item instanceof String) {
                    return (String) item;
                }
            }
        }
        throw new GettextException("Wrong data from ResourceBundle");
    }

}
