package ru.yandex.partner.libs.i18n.resolver.bundle;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

import org.springframework.util.StringUtils;

public class DashResourceBundleNameResolver implements ResourceBundleNameResolver {

    private static final Pattern replacePattern = Pattern.compile("[^-a-zA-Z0-9]");

    private final String baseResourcePath;

    private final Map<String, String> bundleNameCache = new ConcurrentHashMap<>();

    public DashResourceBundleNameResolver() {
        baseResourcePath = null;
    }

    public DashResourceBundleNameResolver(String baseResourcePath) {
        this.baseResourcePath = baseResourcePath;
    }

    public String resolveResourceBundleName(String keysetName) {
        return bundleNameCache.computeIfAbsent(keysetName, this::generateResourcePath);
    }

    private String generateResourcePath(String keysetName) {
        return baseResourcePath == null ? convertKeysetToName(keysetName)
                : baseResourcePath + "." + convertKeysetToName(keysetName);
    }

    private String convertKeysetToName(String keysetName) {
        return StringUtils.trimLeadingCharacter(replacePattern.matcher(keysetName).replaceAll("-"), '-')
                + "." + "messages";
    }

}
