package ru.yandex.partner.libs.i18n.resolver.bundle;

import java.io.File;
import java.nio.file.Path;

public interface ResourceBundleNameResolver {

    String resolveResourceBundleName(String keysetName);

    default Path resolveResourceFilePath(File resourceDirectory, String keyset, String language) {
        String resourceBundleName = resolveResourceBundleName(keyset);

        String filename = String.format("%s_%s.json",
                resourceBundleName.replace(".", File.separator), language);

        return Path.of(resourceDirectory.getAbsolutePath(), filename);
    }

}
