package ru.yandex.partner.libs.i18n.resolver.key;

import ru.yandex.partner.libs.i18n.GettextMsgPayload;

public interface GettextMessageKeyResolver {

    default String getMessageKey(GettextMsgPayload payload) {
        return !payload.isContext() ? generateNonContextualKey(payload.getMsg())
                :generateContextualKey(payload.getMsg(), payload.getContext());
    }

    default String generateNonContextualKey(String msg) {
        return msg;
    }

    String generateContextualKey(String msg, String context);
}
