package ru.yandex.partner.libs.i18n.resolver.plural;

import java.util.Locale;

public class PluralVariantResolverProvider {

    private static final PluralVariantResolver defaultPluralVariantResolver = new DefaultPluralVariantResolver();
    private static final PluralVariantResolver russianPluralVariantResolver = new RussianPluralVariantResolver();

    public static PluralVariantResolver getPluralVariantResolver(String language) {
        if ("ru".equals(language)) {
            return russianPluralVariantResolver;
        }
        return defaultPluralVariantResolver;
    }

    public static PluralVariantResolver getPluralVariantResolver(Locale locale) {
        return getPluralVariantResolver(locale.getLanguage());
    }
}
