package ru.yandex.partner.libs.i18n.resolver.plural;

import java.util.List;

public class RussianPluralVariantResolver implements PluralVariantResolver {

    private static final List<String> VARIANT_DESCRIPTIONS = List.of("1", "2", "5");

    @Override
    public List<String> getVariantDescriptions() {
        return VARIANT_DESCRIPTIONS;
    }

    @Override
    public int resolvePluralVariant(int n) {
        if (n % 10 == 1 && n % 100 != 11) {
            return 0;
        }
        if (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20)) {
            return 1;
        }
        return 2;
    }

}
