package ru.yandex.partner.libs.i18n.tanker.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.partner.libs.i18n.escaper.StringEscaper;
import ru.yandex.partner.libs.i18n.tanker.dto.json.TankerJsonKeyset;
import ru.yandex.partner.libs.i18n.tanker.dto.json.TankerJsonKeysetDoc;
import ru.yandex.partner.libs.i18n.tanker.exception.TankerJsonException;

public class TankerJsonResourceBundle extends ResourceBundle {

    private final Map<String, Object> translations;

    TankerJsonResourceBundle(InputStream stream, StringEscaper stringEscaper) throws IOException {
        TankerJsonKeysetDoc tankerJsonKeysetDoc = (new ObjectMapper()).readValue(stream, TankerJsonKeysetDoc.class);
        Map<String, TankerJsonKeyset> keysets = tankerJsonKeysetDoc.getKeysetEntries();
        if (keysets.size() != 1) {
            throw new TankerJsonException(String.format(
                    "Translation resource file is supposed to contain single keyset, got %s", keysets.size())
            );
        }
        this.translations = keysets.values().iterator().next().getTranslationEntries().entrySet().stream()
                .collect(Collectors.toMap(
                        e -> stringEscaper.unescapeString(e.getKey()),
                        e -> stringEscaper.unsecapeResource(e.getValue())
                ));
    }

    @Override
    protected Object handleGetObject(@Nonnull String key) {
        return translations.get(key);
    }

    @Override
    @Nonnull
    public Enumeration<String> getKeys() {
        return Collections.enumeration(translations.keySet());
    }

}
