package ru.yandex.partner.libs.i18n.tanker.dto.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.partner.libs.i18n.tanker.exception.TranslationParsingException;

public class TankerJsonKeyset {

    private final Map<String, Object> translationEntries;

    public TankerJsonKeyset() {
        translationEntries = new HashMap<>();
    }

    public TankerJsonKeyset(Map<String, Object> translationEntries) {
        this.translationEntries = translationEntries;
    }

    public Map<String, Object> getTranslationEntries() {
        return translationEntries;
    }

    @JsonValue
    public Map<String, Object> getTranslationEntriesSorted() {
        return new TreeMap<>(translationEntries);
    }

    @JsonAnySetter
    public void addEntry(String key, Object object) throws TranslationParsingException {
        if (!checkValidObject(object)) {
            throw new TranslationParsingException(String.format(
                    "Translation value must be ether String or non-empty List of Strings. Key: '%s'", key));
        }
        translationEntries.put(key, object);
    }

    /**
     * @param object some object
     * @return object is ether String or non-empty List of Strings
     */
    protected boolean checkValidObject(Object object) {
        if (object instanceof String) {
            return true;
        }
        if (object instanceof List) {
            List list = (List) object;
            for (Object o : list) {
                if (!(o instanceof String)) {
                    return false;
                }
            }
            return !list.isEmpty();
        }
        return false;
    }

}
