package ru.yandex.partner.libs.i18n.tanker.dto.json;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TankerJsonKeysetDoc {

    private final Map<String, TankerJsonKeyset> keysetEntries;

    public TankerJsonKeysetDoc() {
        keysetEntries = new HashMap<>();
    }

    public TankerJsonKeysetDoc(Map<String, TankerJsonKeyset> keysetEntries) {
        this.keysetEntries = keysetEntries;
    }

    public Map<String, TankerJsonKeyset> getKeysetEntries() {
        return keysetEntries;
    }

    @JsonValue
    public Map<String, TankerJsonKeyset> getTranslationKeysetsSorted() {
        return new TreeMap<>(keysetEntries);
    }

    @JsonAnySetter
    public void addKeyset(String name, TankerJsonKeyset keyset) {
        keysetEntries.put(name, keyset);
    }

}
