package ru.yandex.partner.libs.i18n.tanker.dto.tjson;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TankerDetailedJsonKeys {

    private Map<String, TankerDetailedJsonKey> keys = new HashMap<>();

    public TankerDetailedJsonKeys() {
    }

    public TankerDetailedJsonKeys(Map<String, TankerDetailedJsonKey> keys) {
        this.keys = keys;
    }

    public Map<String, TankerDetailedJsonKey> getKeys() {
        return keys;
    }

    public void setKeys(Map<String, TankerDetailedJsonKey> keys) {
        this.keys = keys;
    }

    @JsonValue
    public Map<String, TankerDetailedJsonKey> getKeysSorted() {
        return new TreeMap<>(keys);
    }

    @JsonAnySetter
    public void addKey(String key, TankerDetailedJsonKey value) {
        keys.put(key, value);
    }

}
