package ru.yandex.partner.libs.i18n.tanker.dto.tjson;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TankerDetailedJsonKeysets {

    private Map<String, TankerDetailedJsonKeyset> keysets = new HashMap<>();

    public TankerDetailedJsonKeysets() {
    }

    public TankerDetailedJsonKeysets(Map<String, TankerDetailedJsonKeyset> keysets) {
        this.keysets = keysets;
    }

    public Map<String, TankerDetailedJsonKeyset> getKeysets() {
        return keysets;
    }

    public void setKeysets(Map<String, TankerDetailedJsonKeyset> keysets) {
        this.keysets = keysets;
    }

    @JsonValue
    public Map<String, TankerDetailedJsonKeyset> getKeysetsSorted() {
        return keysets;
    }

    @JsonAnySetter
    public void addKeyset(String key, TankerDetailedJsonKeyset value) {
        keysets.put(key, value);
    }
}
