package ru.yandex.partner.libs.i18n.tanker.dto.tjson;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class TankerDetailedJsonPluralTranslation extends TankerDetailedJsonTranslation {

    private static final Pattern KEY_PATTERN = Pattern.compile("^form(\\d+)$");

    private List<String> forms;

    public TankerDetailedJsonPluralTranslation() {
    }

    public TankerDetailedJsonPluralTranslation(List<String> forms) {
        this.forms = forms;
    }

    @JsonIgnore
    public List<String> getForms() {
        return forms;
    }

    public void setForms(List<String> forms) {
        this.forms = forms;
    }

    @JsonAnyGetter
    public Map<String, String> getFormsJson() {
        Map<String, String> formsMap = new TreeMap<>();
        int i = 1;
        for (String form : forms) {
            formsMap.put("form" + i, form);
            i++;
        }
        return formsMap;
    }

    @JsonAnySetter
    public void addForm(String key, String value) {
        Matcher matcher = KEY_PATTERN.matcher(key);
        if (matcher.matches()) {
            int i = Integer.parseInt(matcher.group(1));
            while (forms.size() < i + 1) {
                forms.add(null);
            }
            forms.set(i, value);
        }
    }
}
