package ru.yandex.partner.libs.i18n.tanker.dto.tjson;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TankerDetailedJsonTranslations {

    private Map<String, TankerDetailedJsonTranslation> translations = new HashMap<>();

    public TankerDetailedJsonTranslations() {
    }

    public TankerDetailedJsonTranslations(Map<String, TankerDetailedJsonTranslation> translations) {
        this.translations = translations;
    }

    public Map<String, TankerDetailedJsonTranslation> getTranslations() {
        return translations;
    }

    public void setTranslations(Map<String, TankerDetailedJsonTranslation> translations) {
        this.translations = translations;
    }

    @JsonValue
    public Map<String, TankerDetailedJsonTranslation> getTranslationsSorted() {
        return new TreeMap<>(translations);
    }

    @JsonAnySetter
    public void addTranslation(String language, TankerDetailedJsonTranslation tankerDetailedJsonTranslation) {
        translations.put(language, tankerDetailedJsonTranslation);
    }

}
