package ru.yandex.partner.libs.i18n.tanker.sync.dto;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TranslationPatch {

    Map<String, TranslationPatchGroup> groups = new HashMap<>();

    public TranslationPatch() {
    }

    public TranslationPatch(Map<String, TranslationPatchGroup> groups) {
        this.groups = groups;
    }

    @JsonValue
    public Map<String, TranslationPatchGroup> getGroups() {
        return groups;
    }

    public void setGroups(Map<String, TranslationPatchGroup> groups) {
        this.groups = groups;
    }

    @JsonAnySetter
    public void addGroup(String key, TranslationPatchGroup value) {
        groups.put(key, value);
    }

    @Override
    public String toString() {
        return "TranslationPatch{" +
                "groups=" + groups +
                '}';
    }
}
