package ru.yandex.partner.libs.i18n.tanker.sync.dto;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;

public class TranslationPatchGroup {

    private Map<String, Object> translations = new HashMap<>();

    public TranslationPatchGroup() {
    }

    public TranslationPatchGroup(Map<String, Object> translations) {
        this.translations = translations;
    }

    public Map<String, Object> getTranslations() {
        return translations;
    }

    public void setTranslations(Map<String, Object> translations) {
        this.translations = translations;
    }

    @JsonValue
    public Map<String, Object> getTranslationsSorted() {
        return new TreeMap<>(translations);
    }

    @JsonAnySetter
    public void addTranslation(String key, Object value) {
        translations.put(key, value);
    }

    @Override
    public String toString() {
        return "TranslationPatchGroup{" +
                "translations=" + translations +
                '}';
    }
}
