package ru.yandex.partner.libs.i18n.testing;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.resolver.bundle.DashResourceBundleNameResolver;
import ru.yandex.partner.libs.i18n.tanker.bundle.TankerJsonResourceBundleControl;
import ru.yandex.partner.libs.i18n.tanker.escaper.TankerPOStringEscaper;
import ru.yandex.partner.libs.i18n.tanker.resolver.TankerGettextMessageKeyResolver;
import ru.yandex.partner.libs.i18n.translation.Translation;
import ru.yandex.partner.libs.i18n.translation.source.TranslationSource;
import ru.yandex.partner.libs.i18n.translation.source.factory.ResourceBundleTranslationSourceFactory;
import ru.yandex.partner.libs.i18n.translation.source.factory.TranslationSourceFactory;

public class MessageChecker {

    private final MessagesCollector messagesCollector;
    private final TranslationSourceFactory translationSourceFactory;

    public MessageChecker(MessagesCollector messagesCollector,
                          TranslationSourceFactory translationSourceFactory) {
        this.messagesCollector = messagesCollector;
        this.translationSourceFactory = translationSourceFactory;
    }

    public MessageChecker(String basePackage, String baseResourcePath) {
        this(
                new MessagesCollector(basePackage),
                new ResourceBundleTranslationSourceFactory(
                        new TankerJsonResourceBundleControl(new TankerPOStringEscaper(), false),
                        new TankerGettextMessageKeyResolver(),
                        new DashResourceBundleNameResolver(baseResourcePath)
                )
        );
    }

    public Map<GettextMsg, String> findProblems(Locale locale) throws MsgNotEnumException {
        TranslationSource translationSource = translationSourceFactory.getTranslationSource(locale);

        Map<GettextMsg, String> problems = new HashMap<>();

        for (GettextMsg msg : messagesCollector.collectMessages()) {
            Translation translation = translationSource.getTranslation(msg);
            if (translation.isResourceMalformed()) {
                problems.put(msg, "Resource malformed");
            } else if (translation.hasMissingTranslations()) {
                problems.put(msg, "Translation misses some values");
            }
        }

        return problems;
    }

    public Map<Class<? extends GettextMsg>, Map<GettextMsg, String>> findProblemsMappedByClass(Locale locale)
            throws MsgNotEnumException {
        Map<Class<? extends GettextMsg>, Map<GettextMsg, String>> m = new HashMap<>();
        findProblems(locale).forEach(
                (key, value) -> m.computeIfAbsent(key.getClass(), aClass -> new HashMap<>()).put(key, value)
        );
        return m;
    }

    public Set<GettextMsg> findProblematicTranslations(Locale locale) throws MsgNotEnumException {
        return findProblems(locale).keySet();
    }

}
