package ru.yandex.partner.libs.i18n.testing;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import org.reflections.Reflections;

import ru.yandex.partner.libs.i18n.GettextSyncExclude;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.MsgWithArgs;

public class MessagesCollector {

    private final Reflections reflections;

    private final Set<Class<? extends GettextMsg>> ignoredClasses = Set.of(MsgWithArgs.class);

    public MessagesCollector(String basePackage) {
        reflections = new Reflections(basePackage);
    }

    public Set<GettextMsg> collectMessages() throws MsgNotEnumException {

        Set<Class<? extends GettextMsg>> classes = reflections.getSubTypesOf(GettextMsg.class);
        classes.removeAll(ignoredClasses);
        classes.removeIf(GettextSyncExclude.class::isAssignableFrom);

        Set<Class<? extends GettextMsg>> nonEnums = classes.stream()
                .filter(c -> !c.isEnum()).collect(Collectors.toSet());
        if (!nonEnums.isEmpty()) {
            throw new MsgNotEnumException("Classes extending GettextMsg are not enums: " + nonEnums);
        }

        Set<GettextMsg> messages = new HashSet<>();

        for (Class<? extends GettextMsg> c : classes) {
            for (Object a : c.getEnumConstants()) {
                messages.add((GettextMsg) a);
            }
        }

        return messages;
    }

}
