package ru.yandex.partner.libs.i18n.translation.source;

import java.util.List;
import java.util.Locale;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolver;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolverProvider;
import ru.yandex.partner.libs.i18n.translation.Translation;

public abstract class BaseResourceTranslationSource implements TranslationSource {

    @Override
    public Translation getTranslation(GettextMsg gettextMsg) {
        ResourceRetrievalResult result = retrieveResource(gettextMsg);
        return result.getResource() == null ? emptyTranslation(gettextMsg.getPayload(), result.getLocale())
                : convertResourceToTranslation (gettextMsg.getPayload(), result.getResource(), result.getLocale());
    }

    protected abstract ResourceRetrievalResult retrieveResource(GettextMsg gettextMsg);

    protected Translation convertResourceToTranslation(GettextMsgPayload payload, Object resource, Locale locale){
        if (!payload.isPlural()) {
            if (resource instanceof String) {
                return new Translation((String) resource);
            }
            if (resource instanceof List) {
                List<?> listResource = (List<?>) resource;
                if (!listResource.isEmpty() && listResource.get(0) instanceof String) {
                    return new Translation((String) listResource.get(0), true);
                }
            }
            return Translation.getEmptySingleMalformedTranslation();
        } else {
            PluralVariantResolver pluralVariantResolver =
                    PluralVariantResolverProvider.getPluralVariantResolver(locale);

            if (resource instanceof List) {
                boolean resourceMalformed = !checkListOk(resource, pluralVariantResolver.variantsCount());
                return new Translation((List<?>) resource, pluralVariantResolver, resourceMalformed);
            }
            if (resource instanceof String) {
                return new Translation(List.of(resource), pluralVariantResolver, true);
            }
            return Translation.emptyPluralMalformedTranslation(pluralVariantResolver);
        }
    }

    private static boolean checkListOk(Object resource, int count) {
        if (!(resource instanceof List)) {
            return false;
        }
        List<?> list = (List<?>) resource;
        if (list.size() != count) {
            return false;
        }
        return list.stream().allMatch(o -> o instanceof String);
    }

    protected static Translation emptyTranslation(GettextMsgPayload payload, Locale locale) {
        return !payload.isPlural() ? Translation.emptySingleTranslation() : Translation.emptyPluralTranslation(
                PluralVariantResolverProvider.getPluralVariantResolver(locale)
        );
    }

    protected static class ResourceRetrievalResult {
        private final Object resource;
        private final Locale locale;

        public ResourceRetrievalResult(Object resource, Locale locale) {
            this.resource = resource;
            this.locale = locale;
        }

        public Object getResource() {
            return resource;
        }

        public Locale getLocale() {
            return locale;
        }
    }

}
