package ru.yandex.partner.libs.i18n.translation.source;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolver;
import ru.yandex.partner.libs.i18n.translation.Translation;

public class MergingTranslationSource implements TranslationSource {

    private final TranslationSource source1;
    private final TranslationSource source2;

    public MergingTranslationSource(TranslationSource source1, TranslationSource source2) {
        this.source1 = source1;
        this.source2 = source2;
    }

    @Override
    public Translation getTranslation(GettextMsg gettextMsg) {
        Translation translation1 = source1.getTranslation(gettextMsg);
        Translation translation2 = source2.getTranslation(gettextMsg);
        if (!gettextMsg.getPayload().isPlural()) {
            return "".equals(translation2.getTranslation()) ? translation1 : translation2;
        }
        PluralVariantResolver pluralVariantResolver = translation1.getPluralVariantResolver();
        int count = pluralVariantResolver.variantsCount();
        List<String> l1 = translation1.getTranslations();
        List<String> l2 = translation2.getTranslations();
        List<String> merged = new ArrayList<>(count);
        for(int i=0; i<count; i++){
            merged.add(l2.size() <= i || "".equals(l2.get(i)) ? l1.get(i) : l2.get(i));
        }
        return new Translation(merged, pluralVariantResolver);
    }
}
