package ru.yandex.partner.libs.i18n.translation.source;

import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.libs.i18n.resolver.key.GettextMessageKeyResolver;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;
import ru.yandex.partner.libs.i18n.tanker.sync.dto.TranslationPatch;
import ru.yandex.partner.libs.i18n.tanker.sync.dto.TranslationPatchGroup;
import ru.yandex.partner.libs.i18n.resolver.plural.PluralVariantResolver;
import ru.yandex.partner.libs.i18n.translation.Translation;

public class PatchTranslationSource implements TranslationSource {

    private final TranslationPatch patch;
    private final PluralVariantResolver pluralVariantResolver;
    private final GettextMessageKeyResolver gettextMessageKeyResolver;

    public PatchTranslationSource(TranslationPatch patch, PluralVariantResolver pluralVariantResolver,
                                  GettextMessageKeyResolver gettextMessageKeyResolver) {
        this.patch = patch;
        this.pluralVariantResolver = pluralVariantResolver;
        this.gettextMessageKeyResolver = gettextMessageKeyResolver;
    }

    @Override
    public Translation getTranslation(GettextMsg gettextMsg) {
        GettextMsgPayload payload = gettextMsg.getPayload();
        TranslationPatchGroup patchGroup = this.patch.getGroups().get(gettextMsg.getClass().getCanonicalName());
        if (patchGroup == null) {
            return emptyTranslation(payload);
        }
        String fullKey = gettextMessageKeyResolver.getMessageKey(payload);
        Object translation = patchGroup.getTranslations().get(fullKey);
        if (!payload.isPlural() && translation instanceof String) {
            return new Translation((String) translation);
        }
        if (payload.isPlural() && translation instanceof Map) {
            return new Translation(
                    pluralVariantResolver.getVariantDescriptions().stream()
                            .map(variant -> ((Map) translation).get(variant))
                            .collect(Collectors.toList()),
                    pluralVariantResolver);
        }
        return emptyTranslation(payload);
    }

    private Translation emptyTranslation(GettextMsgPayload payload) {
        return !payload.isPlural() ? Translation.emptySingleTranslation()
                : Translation.emptyPluralTranslation(pluralVariantResolver);
    }
}
