package ru.yandex.partner.libs.i18n.translation.source.factory;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.partner.libs.i18n.resolver.bundle.ResourceBundleNameResolver;
import ru.yandex.partner.libs.i18n.resolver.key.GettextMessageKeyResolver;
import ru.yandex.partner.libs.i18n.translation.source.ResourceBundleTranslationSource;
import ru.yandex.partner.libs.i18n.translation.source.TranslationSource;

public class ResourceBundleTranslationSourceFactory implements TranslationSourceFactory {

    private final ResourceBundle.Control resourceBundleControl;
    private final GettextMessageKeyResolver gettextMessageKeyResolver;
    private final ResourceBundleNameResolver resourceBundleNameResolver;

    private final Map<Locale, TranslationSource> translationSources = new ConcurrentHashMap<>();

    public ResourceBundleTranslationSourceFactory(ResourceBundle.Control resourceBundleControl,
                                                  GettextMessageKeyResolver gettextMessageKeyResolver,
                                                  ResourceBundleNameResolver resourceBundleNameResolver) {
        this.resourceBundleControl = resourceBundleControl;
        this.gettextMessageKeyResolver = gettextMessageKeyResolver;
        this.resourceBundleNameResolver = resourceBundleNameResolver;
    }

    @Override
    public TranslationSource getTranslationSource(Locale locale) {
        return translationSources.computeIfAbsent(locale, this::createNewTranslationSource);
    }

    protected ResourceBundle.Control getResourceBundleControl() {
        return resourceBundleControl;
    }

    protected GettextMessageKeyResolver getGettextMessageKeyResolver() {
        return gettextMessageKeyResolver;
    }

    protected ResourceBundleNameResolver getResourceBundleNameResolver() {
        return resourceBundleNameResolver;
    }

    protected TranslationSource createNewTranslationSource(Locale l) {
        return new ResourceBundleTranslationSource(l, this.getResourceBundleControl(),
                this.getGettextMessageKeyResolver(), this.getResourceBundleNameResolver());
    }

}
