package ru.yandex.partner.libs.i18n.translation.source.factory;

import java.io.File;
import java.util.Locale;

import ru.yandex.partner.libs.i18n.escaper.StringEscaper;
import ru.yandex.partner.libs.i18n.resolver.bundle.ResourceBundleNameResolver;
import ru.yandex.partner.libs.i18n.resolver.key.GettextMessageKeyResolver;
import ru.yandex.partner.libs.i18n.translation.source.ResourceFileTranslationSource;
import ru.yandex.partner.libs.i18n.translation.source.TranslationSource;

public class ResourceFileTranslationSourceFactory implements TranslationSourceFactory {

    private final File resourceDirectory;
    private final ResourceBundleNameResolver resourceBundleNameResolver;
    private final GettextMessageKeyResolver gettextMessageKeyResolver;
    private final StringEscaper stringEscaper;

    public ResourceFileTranslationSourceFactory(File resourceDirectory,
                                                ResourceBundleNameResolver resourceBundleNameResolver,
                                                GettextMessageKeyResolver gettextMessageKeyResolver,
                                                StringEscaper stringEscaper) {
        this.resourceDirectory = resourceDirectory;
        this.resourceBundleNameResolver = resourceBundleNameResolver;
        this.gettextMessageKeyResolver = gettextMessageKeyResolver;
        this.stringEscaper = stringEscaper;
    }

    @Override
    public TranslationSource getTranslationSource(Locale locale) {
        return new ResourceFileTranslationSource(resourceDirectory, resourceBundleNameResolver,
                gettextMessageKeyResolver, stringEscaper, locale);
    }

}
