package ru.yandex.partner.libs.i18n.sync;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public class TmpFileHelper {

    private File tmpDir;

    public TmpFileHelper() {
        tmpDir = Path.of("/tmp", UUID.randomUUID().toString()).toFile();
    }

    public File getTmpDir() {
        return tmpDir;
    }

    public void writeTmpFile(String dstResourceName, byte[] resourceInputStream) throws IOException {
        Path resourceFilePath = Path.of(tmpDir.getAbsolutePath(),
                dstResourceName);

        Files.createDirectories(resourceFilePath.getParent());
        Files.write(resourceFilePath, resourceInputStream);
    }

    public byte[] readResource(String resourceName) throws IOException {
        return getClass().getClassLoader()
                .getResourceAsStream(resourceName).readAllBytes();
    }

    public void copyResourceToTmp(String resourceName, String tmpFileName) throws IOException {
        writeTmpFile(tmpFileName, readResource(resourceName));
    }

    public byte[] readTmpFile(String tempFileName) throws IOException {
        return Files.readAllBytes(Path.of(tmpDir.getAbsolutePath(), tempFileName));
    }

}
